/*

Skin Operations Macro Script File

 Created:  		Aug 6 2000
	
 Author :   Peter Watje
 Version:  3ds max 6

 	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 

MacroScript SkinLoopSelection
ButtonText:~SKINLOOPSELECTION_BUTTONTEXT~
Category:~SKINLOOPSELECTION_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SKINLOOPSELECTION_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)	
	on execute do
	(
		skinOps.loopSelection (modPanel.GetcurrentObject())
	)
)

MacroScript SkinRingSelection
ButtonText:~SKINRINGSELECTION_BUTTONTEXT~
Category:~SKINRINGSELECTION_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SKINRINGSELECTION_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)	
	on execute do
	(
		skinOps.ringSelection (modPanel.GetcurrentObject())
	)
)

MacroScript SkinGrowSelection
ButtonText:~SKINGROWSELECTION_BUTTONTEXT~
Category:~SKINGROWSELECTION_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SKINGROWSELECTION_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)	
	on execute do
	(
		skinOps.growSelection (modPanel.GetcurrentObject())
	)
)

MacroScript SkinShrinkSelection
ButtonText:~SKINSHRINKSELECTION_BUTTONTEXT~
Category:~SKINSHRINKSELECTION_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SKINSHRINKSELECTION_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)	
	on execute do
	(
		skinOps.shrinkSelection (modPanel.GetcurrentObject())
	)
)

MacroScript SkinSelectVerticesByBone
ButtonText:~SKINSELECTVERTICESBYBONE_BUTTONTEXT~
Category:~SKINSELECTVERTICESBYBONE_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SKINSELECTVERTICESBYBONE_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)	
	on execute do
	(
		skinOps.selectVerticesByBone (modPanel.GetcurrentObject())
	)
)



MacroScript WeightTable_Dialog
ButtonText:~WEIGHTTABLE_DIALOG_BUTTONTEXT~
Category:~WEIGHTTABLE_DIALOG_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~WEIGHTTABLE_DIALOG_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isChecked return 
	(
		if (classof(modPanel.GetcurrentObject())) == Skin then
		(
			bopen = skinOps.isWeightTableOpen (modPanel.GetcurrentObject())
			if (bopen != 0) then true
		)
		else 
		(
			false
		)
	)
	
	on closeDialogs do 
	(
		skinOps.closeWeightTable  (modPanel.GetcurrentObject())
	) 
	
	on execute do
	(
		skinOps.WeightTable  (modPanel.GetcurrentObject())
	)
)
MacroScript BlendWeights
ButtonText:~BLENDWEIGHTS_BUTTONTEXT~
Category:~BLENDWEIGHTS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~BLENDWEIGHTS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.blendSelected (modPanel.GetcurrentObject())
	)
)

MacroScript RemoveZeroWeights
ButtonText:~REMOVEZEROWEIGHTS_BUTTONTEXT~
Category:~REMOVEZEROWEIGHTS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~REMOVEZEROWEIGHTS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.RemoveZeroWeights (modPanel.GetcurrentObject())
	)
)

MacroScript WeightTool_Dialog
ButtonText:~WEIGHTTOOL_DIALOG_BUTTONTEXT~
Category:~WEIGHTTOOL_DIALOG_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~WEIGHTTOOL_DIALOG_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isChecked return 
	(
		if (classof(modPanel.GetcurrentObject())) == Skin then
		(
			local bopen = skinOps.isWeightToolOpen (modPanel.GetcurrentObject())
			if (bopen != 0) then true
		)
		else
		(
			false
		)
	)	
	on closeDialogs do 
	(
		skinOps.closeWeightTool  (modPanel.GetcurrentObject())
	) 
	
	on execute do
	(
		skinOps.WeightTool  (modPanel.GetcurrentObject())
	)
)

MacroScript SetWeight_00
ButtonText:~SETWEIGHT_00_BUTTONTEXT~
Category:~SETWEIGHT_00_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SETWEIGHT_00_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SetWeight  (modPanel.GetcurrentObject()) 0.0
	)
)

MacroScript SetWeight_01
ButtonText:~SETWEIGHT_01_BUTTONTEXT~
Category:~SETWEIGHT_01_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SETWEIGHT_01_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SetWeight  (modPanel.GetcurrentObject()) 0.1
	)
)

MacroScript SetWeight_25
ButtonText:~SETWEIGHT_25_BUTTONTEXT~
Category:~SETWEIGHT_25_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SETWEIGHT_25_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SetWeight  (modPanel.GetcurrentObject()) 0.25
	)
)

MacroScript SetWeight_50
ButtonText:~SETWEIGHT_50_BUTTONTEXT~
Category:~SETWEIGHT_50_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SETWEIGHT_50_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SetWeight  (modPanel.GetcurrentObject()) 0.5
	)
)

MacroScript SetWeight_75
ButtonText:~SETWEIGHT_75_BUTTONTEXT~
Category:~SETWEIGHT_75_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SETWEIGHT_75_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SetWeight  (modPanel.GetcurrentObject()) 0.75
	)
)

MacroScript SetWeight_90
ButtonText:~SETWEIGHT_90_BUTTONTEXT~
Category:~SETWEIGHT_90_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SETWEIGHT_90_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(	
		skinOps.SetWeight  (modPanel.GetcurrentObject()) 0.90
	)
)

MacroScript SetWeight_100
ButtonText:~SETWEIGHT_100_BUTTONTEXT~
Category:~SETWEIGHT_100_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SETWEIGHT_100_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SetWeight  (modPanel.GetcurrentObject()) 1.0
	)
)

MacroScript SetWeight_Custom
ButtonText:~SETWEIGHT_CUSTOM_BUTTONTEXT~
Category:~SETWEIGHT_CUSTOM_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SETWEIGHT_CUSTOM_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		tmod = modPanel.GetcurrentObject()
		v = tmod.weightTool_weight
		skinOps.SetWeight  (modPanel.GetcurrentObject()) v
	)
)

MacroScript AddWeight
ButtonText:~ADDWEIGHT_BUTTONTEXT~
Category:~ADDWEIGHT_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~ADDWEIGHT_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.AddWeight  (modPanel.GetcurrentObject()) 0.05
	)
)

MacroScript SubtractWeight
ButtonText:~SUBTRACTWEIGHT_BUTTONTEXT~
Category:~SUBTRACTWEIGHT_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SUBTRACTWEIGHT_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.AddWeight  (modPanel.GetcurrentObject()) -0.05
	)
)

MacroScript ScaleWeight_Custom
ButtonText:~SCALEWEIGHT_CUSTOM_BUTTONTEXT~
Category:~SCALEWEIGHT_CUSTOM_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SCALEWEIGHT_CUSTOM_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		tmod = modPanel.GetcurrentObject()
		v = tmod.weightTool_scale
		skinOps.ScaleWeight  (modPanel.GetcurrentObject()) v
	)
)

MacroScript ScaleWeight_Up
ButtonText:~SCALEWEIGHT_UP_BUTTONTEXT~
Category:~SCALEWEIGHT_UP_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SCALEWEIGHT_UP_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.ScaleWeight  (modPanel.GetcurrentObject()) 1.05
	)
)

MacroScript ScaleWeight_Down
ButtonText:~SCALEWEIGHT_DOWN_BUTTONTEXT~
Category:~SCALEWEIGHT_DOWN_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SCALEWEIGHT_DOWN_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.ScaleWeight  (modPanel.GetcurrentObject()) 0.95
	)
)

MacroScript CopyWeights
ButtonText:~COPYWEIGHTS_BUTTONTEXT~
Category:~COPYWEIGHTS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~COPYWEIGHTS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.CopyWeights  (modPanel.GetcurrentObject())
	)
)

MacroScript PasteWeights
ButtonText:~PASTEWEIGHTS_BUTTONTEXT~
Category:~PASTEWEIGHTS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~PASTEWEIGHTS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.PasteWeights  (modPanel.GetcurrentObject())
	)
)


MacroScript PasteWeightsByPos
ButtonText:~PASTEWEIGHTSBYPOS_BUTTONTEXT~
Category:~PASTEWEIGHTSBYPOS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~PASTEWEIGHTSBYPOS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		tmod = modPanel.GetcurrentObject()
		v = tmod.weightTool_tolerance		
		skinOps.pasteWeightsByPos (modPanel.GetcurrentObject()) v
	)
)


MacroScript selectParent
ButtonText:~SELECTPARENT_BUTTONTEXT~
Category:~SELECTPARENT_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTPARENT_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SelectParent  (modPanel.GetcurrentObject()) 
	)
)

MacroScript selectChild
ButtonText:~SELECTCHILD_BUTTONTEXT~
Category:~SELECTCHILD_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTCHILD_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SelectChild  (modPanel.GetcurrentObject()) 
	)
)

MacroScript selectNextSibling
ButtonText:~SELECTNEXTSIBLING_BUTTONTEXT~
Category:~SELECTNEXTSIBLING_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTNEXTSIBLING_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SelectNextSibling  (modPanel.GetcurrentObject()) 
	)
)

MacroScript selectPreviousSibling
ButtonText:~SELECTPREVIOUSSIBLING_BUTTONTEXT~
Category:~SELECTPREVIOUSSIBLING_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTPREVIOUSSIBLING_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SelectPreviousSibling  (modPanel.GetcurrentObject()) 
	)
)




MacroScript backFaceCullVertices
ButtonText:~BACKFACECULLVERTICES_BUTTONTEXT~
Category:~BACKFACECULLVERTICES_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~BACKFACECULLVERTICES_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on isChecked return 
	(
		if (classof(modPanel.GetcurrentObject())) == Skin then (
			(modPanel.GetcurrentObject()).backfacecull
		)
		else (
			false
		)
	)
	
	on execute do
	(
		if  (modPanel.GetcurrentObject()).backfacecull then
			(modPanel.GetcurrentObject()).backfacecull = false
		else  (modPanel.GetcurrentObject()).backfacecull = true
	)
)


MacroScript AddBonesFromView
ButtonText:~ADDBONESFROMVIEW_BUTTONTEXT~
Category:~ADDBONESFROMVIEW_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~ADDBONESFROMVIEW_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		pushprompt ~ADDBONESFROMVIEW_PUSHPROMPT_CAPTION~
		skinOps.AddBoneFromViewStart  (modPanel.GetcurrentObject())
	)
)

MacroScript multiRemove
ButtonText:~MULTIREMOVE_BUTTONTEXT~
Category:~MULTIREMOVE_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~MULTIREMOVE_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.MultiRemove  (modPanel.GetcurrentObject())
	)
)

MacroScript selectPrevious
ButtonText:~SELECTPREVIOUS_BUTTONTEXT~
Category:~SELECTPREVIOUS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTPREVIOUS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SelectPreviousBone  (modPanel.GetcurrentObject()) 
	)
)

MacroScript selectNext
ButtonText:~SELECTNEXT_BUTTONTEXT~
Category:~SELECTNEXT_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTNEXT_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.SelectNextBone  (modPanel.GetcurrentObject())
	)
)

MacroScript zoomToBone
ButtonText:~ZOOMTOBONE_BUTTONTEXT~
Category:~ZOOMTOBONE_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~ZOOMTOBONE_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.ZoomToBone  (modPanel.GetcurrentObject()) FALSE
	)
)

MacroScript zoomToGizmo
ButtonText:~ZOOMTOGIZMO_BUTTONTEXT~
Category:~ZOOMTOGIZMO_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~ZOOMTOGIZMO_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.ZoomToGizmo  (modPanel.GetcurrentObject()) FALSE
	)
)


MacroScript selectEndPoint
ButtonText:~SELECTENDPOINT_BUTTONTEXT~
Category:~SELECTENDPOINT_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTENDPOINT_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on Execute do
	(
		skinOps.SelectEndPoint  (modPanel.GetcurrentObject())
	)
)

MacroScript selectStartPoint
ButtonText:~SELECTSTARTPOINT_BUTTONTEXT~
Category:~SELECTSTARTPOINT_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTSTARTPOINT_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on Execute do
	(
		skinOps.SelectStartPoint  (modPanel.GetcurrentObject())
	)
)

MacroScript filterVertices
ButtonText:~FILTERVERTICES_BUTTONTEXT~
Category:~FILTERVERTICES_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~FILTERVERTICES_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isChecked return 
	(
		if (classof(modPanel.GetcurrentObject())) == Skin then (
			(modPanel.GetcurrentObject()).filter_vertices
		)
		else (
			false
		)
	)
	
	on execute do
	(
		if  (modPanel.GetcurrentObject()).filter_vertices then
		(modPanel.GetcurrentObject()).filter_vertices = FALSE
		else  (modPanel.GetcurrentObject()).filter_vertices = TRUE
	)
)

MacroScript filterEnvelopes
ButtonText:~FILTERENVELOPES_BUTTONTEXT~
Category:~FILTERENVELOPES_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~FILTERENVELOPES_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isChecked return 
	(
		if (classof(modPanel.GetcurrentObject())) == Skin then (
			(modPanel.GetcurrentObject()).filter_cross_sections
		)
		else (
			false
		)
	)	
	
	on execute do
	(
		if  (modPanel.GetcurrentObject()).filter_cross_sections then
			(modPanel.GetcurrentObject()).filter_cross_sections  = FALSE
		else  (modPanel.GetcurrentObject()).filter_cross_sections  = TRUE
	)
)

MacroScript filterCrossSections
ButtonText:~FILTERCROSSSECTIONS_BUTTONTEXT~
Category:~FILTERCROSSSECTIONS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~FILTERCROSSSECTIONS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isChecked return 
	(
		if (classof(modPanel.GetcurrentObject())) == Skin then (
			(modPanel.GetcurrentObject()).filter_envelopes
		)
		else ( 
			false
		)
	)	
	
	on execute do
	(
		if  (modPanel.GetcurrentObject()).filter_envelopes then
		(modPanel.GetcurrentObject()).filter_envelopes  = false
		else  (modPanel.GetcurrentObject()).filter_envelopes  = true
	)
)

MacroScript excludeVerts
ButtonText:~EXCLUDEVERTS_BUTTONTEXT~
Category:~EXCLUDEVERTS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~EXCLUDEVERTS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	
	on Execute do
	(
		skinOps.ButtonExclude  (modPanel.GetcurrentObject())
	)
)

MacroScript includeVerts
ButtonText:~INCLUDEVERTS_BUTTONTEXT~
Category:~INCLUDEVERTS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~INCLUDEVERTS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	
	on Execute do
	(
		skinOps.ButtonInclude  (modPanel.GetcurrentObject())
	)
)

MacroScript selectIncludeVerts
ButtonText:~SELECTINCLUDEVERTS_BUTTONTEXT~
Category:~SELECTINCLUDEVERTS_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~SELECTINCLUDEVERTS_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	
	on execute do
	(
		skinOps.ButtonSelectExcluded  (modPanel.GetcurrentObject())
	)
)

-- Added August 27 2000 Fred Ruff

MacroScript CopySelectedBone
ButtonText:~COPYSELECTEDBONE_BUTTONTEXT~
Category:~COPYSELECTEDBONE_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~COPYSELECTEDBONE_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	
	on execute do
	(
		skinOps.copySelectedBone (modPanel.GetcurrentObject())
	)
)
MacroScript PasteToSelectedBone
ButtonText:~PASTETOSELECTEDBONE_BUTTONTEXT~
Category:~PASTETOSELECTEDBONE_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~PASTETOSELECTEDBONE_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	
	on execute do
	(
		skinOps.PasteToSelectedBone (modPanel.GetcurrentObject())
	)
)
MacroScript PasteToAllBones
ButtonText:~PASTETOALLBONES_BUTTONTEXT~
Category:~PASTETOALLBONES_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~PASTETOALLBONES_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	
	on execute do
	(
		skinOps.PasteToAllBones  (modPanel.GetcurrentObject())
	)
)
MacroScript AddCrossSection
ButtonText:~ADDCROSSSECTION_BUTTONTEXT~
Category:~ADDCROSSSECTION_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~ADDCROSSSECTION_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin) 
	
	on execute do
	(
		skinOps.ButtonAddCrossSection  (modPanel.GetcurrentObject())
	)
)
MacroScript RemoveCrossSection
ButtonText:~REMOVECROSSSECTION_BUTTONTEXT~
Category:~REMOVECROSSSECTION_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~REMOVECROSSSECTION_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin) 
	
	on execute do
	(
		skinOps.ButtonRemoveCrossSection  (modPanel.GetcurrentObject())
	)
)
MacroScript DrawEnvelopeOnTop
ButtonText:~DRAWENVELOPEONTOP_BUTTONTEXT~
Category:~DRAWENVELOPEONTOP_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~DRAWENVELOPEONTOP_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on isChecked return 
	(
		if (classof(modPanel.GetcurrentObject())) == Skin then (
		 	(modPanel.GetcurrentObject()).envelopesAlwaysOnTop
		)
		else
		(
			false
		)
	)
	
	on execute do
	(
		if Selection[1].modifiers[#Skin].envelopesAlwaysOnTop then
		Selection[1].modifiers[#Skin].envelopesAlwaysOnTop = FALSE
		else Selection[1].modifiers[#Skin].envelopesAlwaysOnTop = TRUE
	)
)

MacroScript DrawCrossSectionsOnTop
ButtonText:~DRAWCROSSSECTIONSONTOP_BUTTONTEXT~
Category:~DRAWCROSSSECTIONSONTOP_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~DRAWCROSSSECTIONSONTOP_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ((classof(modPanel.GetcurrentObject())) == Skin)
	on isChecked return 
	(
		if (classof(modPanel.GetcurrentObject())) == Skin then 
		(
			(modPanel.GetcurrentObject()).crossSectionsAlwaysOnTop
		)
		else 
		(
			false
		)
	)
	
	on execute do
	(
		if (modPanel.GetcurrentObject()).crossSectionsAlwaysOnTop then
			(modPanel.GetcurrentObject()).crossSectionsAlwaysOnTop = false
		else  (modPanel.GetcurrentObject()).crossSectionsAlwaysOnTop = true
	)
)

MacroScript GizmoResetRotationPlane
ButtonText:~GIZMORESETROTATIONPLANE_BUTTONTEXT~
Category:~GIZMORESETROTATIONPLANE_CATEGORY~ 
internalCategory:"Skin Modifier" 
Tooltip:~GIZMORESETROTATIONPLANE_TOOLTIP~ 
-- Needs Icon
(
	on isVisible return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on isEnabled return ( (classof(modPanel.GetcurrentObject())) == Skin)
	on execute do
	(
		skinOps.GizmoResetRotationPlane (modPanel.GetcurrentObject())
	)
)

